#pragma once

#include "../../../debug/exception.h"

#include "../../buffer.h"

#include "../base.h"
#include "../reader.h"
#include "../encode.h"

#include "header.h"
#include "object.h"

namespace storage::fs::spc0
{
	/* reader class */
	class reader : public storage::fs::reader_base
	{
	public:
		// import constructor
		using storage::fs::reader_base::reader_base;

		virtual std::shared_ptr<object_base> create_object(void) const override
		{
			return std::make_shared<storage::fs::spc0::object>();
		}

#if 0
		// decoder are not supported in SPC0
		virtual void set_decoder(std::shared_ptr<decoder_base>) override
		{
			throwException(UnableToSetKeyException);
		}

		// return encoder type
		virtual std::string get_crypto_factory_name(void) const override
		{
			return "";
		}

		// file is never encrypted
		virtual bool is_encrypted(void) const override
		{
			return false;
		}

		// file has never signatures
		virtual bool hasSignatures(void) const override
		{
			return false;
		}
#endif

		// file always has data
		virtual bool has_data(void) const override
		{
			return true;
		}

#if 0
		// get list of signatures
		virtual std::list <std::shared_ptr<const signature_base>> get_signatures(void) override
		{
			return std::list<std::shared_ptr<const signature_base>>();
		}
#endif

		// get list of storage buffer
		virtual std::list<storage::buffer> get_list(void) override
		{
			// prepare return
			std::list<storage::buffer> ret;

			// get copy of buffer
			auto buffer = get();

			// initialize buffer
			initialize(buffer);

			// read header
			auto hdr = buffer.ptr<struct header_s>(0, sizeof(struct header_s));

			auto buffer_data_ofs = MAKE_SIZE_T(ftoh(hdr->buffers_data_offset));
			auto buffer_table_ofs = MAKE_SIZE_T(ftoh(hdr->buffers_table_offset));
			auto num_buffers = MAKE_SIZE_T(ftoh(hdr->num_buffers));

			// get data
			auto offsets_table = buffer.ptr<struct buffer_s>(buffer_table_ofs, MAKE_MULT(sizeof(struct buffer_s), num_buffers));
			auto data = buffer.ptr<unsigned char>(buffer_data_ofs);

			for (size_t i = 0; i < num_buffers; i++)
			{
				auto curr_encoding = ftoh(offsets_table[i].encoding);
				auto curr_offset = MAKE_SIZE_T(ftoh(offsets_table[i].offset));
				auto curr_size = MAKE_SIZE_T(ftoh(offsets_table[i].size));

				if (MAKE_ADD(curr_offset, curr_size) > buffer.size())
					throw_exception(invalid_buffer_exception);

				storage::buffer temp_buffer(MAKE_ADDRESS(data, curr_offset), curr_size);

				ret.push_back(decode(temp_buffer, curr_encoding));
			}

			// return list
			return ret;
		}
	};
};