#pragma once

#include <string>

#include "../../debug/exception.h"

#include "../buffer.h"

#include "object.h"

namespace storage::fs
{
#pragma pack(push, 8)
	struct header_s
	{
		uint32_t ident;
		uint32_t checksum;
		uint64_t _reserved1[2]; // to be kept for historical reason
		uint32_t seed;
		uint32_t _reserved2[12]; // to be kept for historical reason
	};
#pragma pack(pop)

	class writer_base;
	class reader_base;

#if 0
	class signature_base;

	class encoder_base;
	class decoder_base;
#endif

	// interface for storage file system
	class base
	{
	public:
		friend class writer_base;
		friend class reader_base;

		base(uint32_t file_type, uint32_t encryption_key, size_t encryption_block_size)
		{
			this->m_file_type = file_type;

			this->m_encryption_key = encryption_key;
			this->m_encryption_block_size = encryption_block_size;
		}

		virtual ~base(void) {}

		virtual std::shared_ptr<object_base> create_object(void) const = 0;

	protected:

		// set buffer
		void set(const storage::buffer& buf)
		{
			this->m_buffer = buf;
		}

		// get const version of buffer
		const storage::buffer& get(void) const
		{
			return this->m_buffer;
		}

	private:

		// simple encryption function for avalanche effect
		void encrypt(uint32_t* p, size_t num_elems, uint32_t encryption_key, bool forward) const
		{
			if (this->m_encryption_block_size == 0)
				return;

			auto repmat = [](uint32_t value)
			{
				value &= 0xFF;

				value |= value << 8;
				value |= value << 16;

				return ~value;
			};

			encryption_key += repmat((uint32_t)num_elems);

			for (size_t j = 0; j < this->m_encryption_block_size; j++)
				for (size_t i = j; i < num_elems; i = MAKE_ADD(i, this->m_encryption_block_size))
				{
					auto temp = ~p[i];

					p[i] ^= encryption_key;

					encryption_key += forward ? ~p[i] : temp;
					encryption_key += repmat((uint32_t)i);
				}
		}

		storage::buffer m_buffer;

		uint32_t m_file_type;
		uint32_t m_encryption_key;

		size_t m_encryption_block_size;
	};
};
