#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"
#include "../debug/safe.h"
#include "../instancers/instancer.h"

#include "buffer.h"
#include "base.h"
#include "exception.h"

#include "fs/base.h"
#include "fs/reader.h"
#include "fs/writer.h"
#include "fs/object.h"

#include <vector>
#include <tuple>
#include <list>
#include <string>
#include <functional>
#include <ios>
#include <fstream>
#include <memory>

#define DEFAULT_ENCODING_FLAGS			0

#if 0
class crypto_factory_base;
#endif

namespace storage
{
	/* container class */
	class container : public std::list<std::tuple<std::string, std::string, std::shared_ptr<storage::base>>>
	{
	public:
		friend class fs::base;

		container(uint32_t encryption_key = 0xfeedbeef, size_t encryption_block_size = 4)
		{
			this->m_encryption_key = encryption_key;
			this->m_encryption_block_size = encryption_block_size;
		}

#if 0
		// add signature to file
		void add_signature(std::shared_ptr<const signature_base> pSignature)
		{
			if (pSignature != nullptr)
				this->m_signatures.push_back(pSignature);
		}

		// retrieve signatures
		std::list< std::shared_ptr<const signature_base> > get_signatures(void) const
		{
			return this->m_signatures;
		}

		// set encoder
		void set_encoder(std::shared_ptr<const encoder_base> pEncoder)
		{
			this->m_pEncoder = pEncoder;
		}
#endif

		// get by owner
		std::list<std::shared_ptr<storage::base>> get_by_owner(const std::string& owner_search) const
		{
			std::list<std::shared_ptr<storage::base>> ret;

			for (auto it = begin(); it != end(); it++)
			{
				std::string owner, name;
				std::shared_ptr<storage::base> obj;

				std::tie(owner, name, obj) = *it;

				if (obj == nullptr)
					continue;

				if (owner == owner_search)
					ret.push_back(obj);
			}

			return ret;
		}

		// get by name
		std::list<std::shared_ptr<storage::base>> get_by_name(const std::string& name_search) const
		{
			std::list<std::shared_ptr<storage::base>> ret;

			for (auto it = begin(); it != end(); it++)
			{
				std::string owner, name;
				std::shared_ptr<storage::base> obj;

				std::tie(owner, name, obj) = *it;

				if (obj == nullptr)
					continue;

				if (name == name_search)
					ret.push_back(obj);
			}

			return ret;
		}

		// get by owner and name
		std::list<std::shared_ptr<storage::base>> get_by_owner_and_name(const std::string& owner_search, const std::string& name_search) const
		{
			std::list<std::shared_ptr<storage::base>> ret;

			for (auto it = begin(); it != end(); it++)
			{
				std::string owner, name;
				std::shared_ptr<storage::base> obj;

				std::tie(owner, name, obj) = *it;

				if (obj == nullptr)
					continue;

				if (owner == owner_search && name == name_search)
					ret.push_back(obj);
			}

			return ret;
		}

		// get by type
		std::list<std::shared_ptr<storage::base>> get_by_type(const std::string& type_search) const
		{
			std::list<std::shared_ptr<storage::base>> ret;

			for (auto it = begin(); it != end(); it++)
			{
				std::string owner, name;
				std::shared_ptr<storage::base> obj;

				std::tie(owner, name, obj) = *it;

				if (obj == nullptr)
					continue;

				if (is_type_name(obj->get_typename(), type_search))
					ret.push_back(obj);
			}

			return ret;
		}

		void push_front(const std::string& owner, const std::string& name, std::shared_ptr<storage::base> object)
		{
			this->list::push_front(std::tuple<std::string, std::string, std::shared_ptr<storage::base>>(owner, name, object));
		}

		void push_front(std::shared_ptr<storage::base> object)
		{
			push_front("", "", object);
		}

		void push_back(const std::string& owner, const std::string& name, std::shared_ptr<storage::base> object)
		{
			this->list::push_back(std::tuple<std::string,std::string,std::shared_ptr<storage::base>>(owner, name, object));
		}

		void push_back(std::shared_ptr<storage::base> object)
		{
			push_back("", "", object);
		}

		// pack to storage buffer
		buffer pack(uint32_t file_type, unsigned long encoding_flags = DEFAULT_ENCODING_FLAGS)
		{
			// create storage system first
			auto fs = pack_ex(file_type, encoding_flags);

			if (fs == nullptr)
				throw_exception(invalid_filesystem_exception);

			// pack into final buffer without further notice
			return fs->pack();
		}

		// extended packing
		std::shared_ptr<fs::writer_base> pack_ex(uint32_t file_type, unsigned long encoding_flags = DEFAULT_ENCODING_FLAGS)
		{
			if (!endian::is_little_endian())
				throw_exception(bigendian_exception);

			// create file system
			auto fs = fs::create_writer(file_type, this->m_encryption_key, this->m_encryption_block_size, encoding_flags);

			if (fs == nullptr)
				throw_exception(invalid_filesystem_exception);

			// create list
			std::list<buffer> list;

			for (auto it = begin(); it != end(); it++)
			{
				std::string owner, name;
				std::shared_ptr<storage::base> obj;

				std::tie(owner, name, obj) = *it;

				if (obj == nullptr)
					continue;

				// dump base to object
				auto object = fs->create_object();

				object->set_owner_name(owner);
				object->set_var_name(name);

				obj->push(*object);

				// add buffer to list
				list.push_back(object->pack());
			}

			// create buffer from list
			fs->create(list);

#if 0
			// set key
			fs->set_encoder(this->m_pEncoder);

			// add signatures
			for (auto it = this->m_signatures.begin(); it != this->m_signatures.end(); it++)
				pStorageFileSystem->add_signature(*it);
#endif

			return fs;
		}

		// unpack from storage buffer
		void unpack(const buffer& buffer, std::function<std::shared_ptr<storage::base>(const std::string&)> _create = &::create_instance<storage::base>);

		// extended unpacking
		std::shared_ptr<fs::reader_base> unpack_ex(const buffer& buffer)
		{
			if (!endian::is_little_endian())
				throw_exception(bigendian_exception);

			// first bytes should always be identification field
			const uint32_t* ident = buffer.ptr<uint32_t>(0, sizeof(uint32_t));

			// create file system
			auto fs = fs::create_reader(*ident, this->m_encryption_key, this->m_encryption_block_size);

			if (fs == nullptr)
				throw_exception(invalid_filesystem_exception);

			// unpack
			fs->unpack(buffer);

			return fs;
		}

		// unpack from storage buffer list
		void load_objects(std::shared_ptr<storage::fs::reader_base> fs, std::function<std::shared_ptr<storage::base>(const std::string&)> _create = &::create_instance<storage::base>)
		{
			if(fs == nullptr)
				throw_exception(invalid_filesystem_exception);

			// retrieve list
			clear();

			const std::list<buffer>& list = fs->get_list();

			for (auto& v : list)
			{
				// unpack to object
				auto object = fs->create_object();

				if (object == nullptr)
					continue;

				object->unpack(v);

				// create base
				auto obj = _create(object->get_type_name());

				if (obj == nullptr)
					continue;

				obj->pop(*object);

				push_back(object->get_owner_name(), object->get_var_name(), std::move(obj));
			}

#if 0
			// import signatures
			auto signatures_list = fs->get_signatures();

			for (auto it = signatures_list.begin(); it != signatures_list.end(); it++)
				add_signature(*it);
#endif
		}

	private:

#if 0
		std::list< std::shared_ptr<const signature_base> > m_signatures;
		std::shared_ptr<const encoder_base> m_pEncoder;
#endif

		uint32_t m_encryption_key;

		size_t m_encryption_block_size;
	};
};
