#pragma once

#include "../debug/exception.h"

#include <string>

/* cannot_write_data_exception exception class */
class cannot_write_data_exception : public exception::base
{
public:
	cannot_write_data_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("Cannot write to file \"") + this->m_filename + std::string("\" !");
	}

private:
	std::string m_filename;
};

/* cannot_read_data_exception exception class */
class cannot_read_data_exception : public exception::base
{
public:
	cannot_read_data_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("Cannot read from file \"") + this->m_filename + std::string("\" !");
	}

private:
	std::string m_filename;
};