#pragma once

#include "../../utils/utils.h"
#include "../../debug/exception.h"
#include "../../debug/evemon.h"
#include "../../debug/exdebug.h"
#include "../../message/handler.h"
#include "../../instancers/local_instancer.h"
#include "../../storage/base.h"

#include "../endpoint.h"

#include "exception.h"

#include <memory>

namespace net::session
{
	template<class msg_type> class session_base;

	/* state class */
	template<class msg_type> class state : public message::handler<msg_type, net::endpoint<msg_type>&>, public instancer::local<msg_type>, public storage::base
	{
	public:
		IMPLEMENT_STORAGE;

	public:
		state(session_base<msg_type>& parent) : m_parent(parent) {}

		// process incomming buffer
		bool process(const storage::buffer& msg, net::endpoint<msg_type>& endpoint)
		{
			// unpack object
			auto storage_object = endpoint.unpack(msg);

			// create instance based on object name
			auto obj = this->create_instance(storage_object->get_type_name());

			// retrieve object
			obj->pop(*storage_object);

			// handle object
			return this->handle(*obj, endpoint);
		}

		// retrieve session id
		const std::string& id(void) const
		{
			return parent<>().id();
		}

	protected:

		// push new state
		template<typename type, typename ... params> std::shared_ptr<type> push_state(params ... args)
		{
			auto p = std::make_shared<type>(parent<>(), args ...);

			if(!__ISNULLPTR(p))
				parent<>().push_state(p);

			return p;
		}

		// retrieve parent
		template<typename type=session_base<msg_type>> type& parent(void)
		{
			return static_cast<type&>(this->m_parent);
		}

		// retrieve parent
		template<typename type=session_base<msg_type>> const type& parent(void) const
		{
			return static_cast<const type&>(this->m_parent);
		}

		// send data through session (includes session id in message)
		bool send(const msg_type& msg, net::endpoint<msg_type>& endpoint)
		{
			return this->m_parent.send(msg, endpoint);
		}

	private:
		session_base<msg_type>& m_parent;
	};
};