#pragma once

#include "../../storage/base.h"
#include "../../storage/ext/buffer.h"
#include "../../storage/ext/string.h"

namespace net::session
{
	/* session message */
	template<class msg_type> class msg_base : public msg_type
	{
	public:
		IMPLEMENT_STORAGE;

	public:
		msg_base(void) {}

		msg_base(const std::string& id, const storage::buffer& data)
		{
			this->m_id = id;
			this->m_data = data;
		}

		const std::string& id(void) const
		{
			return this->m_id;
		}

		const storage::buffer& data(void) const
		{
			return this->m_data;
		}

	private:
		storage::ext::string m_id;
		storage::ext::buffer m_data;
	};
};