#pragma once

#include "../../debug/exception.h"

#include <string>

/* unknown_session_exception exception class */
class unknown_session_exception : public exception::base
{
public:
	unknown_session_exception(const std::string& id)
	{
		this->m_id = id;
	}

	virtual std::string to_string(void) const override
	{
		return "Session \"" + this->m_id + "\" was not found!";
	}

private:
	std::string m_id;
};

/* session_already_exist_exception exception class */
class session_already_exist_exception : public exception::base
{
public:
	session_already_exist_exception(const std::string& id)
	{
		this->m_id = id;
	}

	virtual std::string to_string(void) const override
	{
		return "Session \"" + this->m_id + "\" already exists!";
	}

private:
	std::string m_id;
};

/* cannot_create_directory_exception exception class */
class cannot_create_directory_exception : public exception::base
{
public:
	cannot_create_directory_exception(const std::string& directory)
	{
		this->m_directory = directory;
	}

	virtual std::string to_string(void) const override
	{
		return "Cannot create directory \"" + this->m_directory + "\" !";
	}

private:
	std::string m_directory;
};

/* failed_loading_session_exception exception class */
class failed_loading_session_exception : public exception::base
{
public:
	failed_loading_session_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return "Failed loading session from file \"" + this->m_filename + "\" !";
	}

private:
	std::string m_filename;
};

/* cannot_offline_exception exception class */
class cannot_offline_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot offline session!";
	}
};

/* invalid_state_exception exception class */
class invalid_state_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid state!";
	}
};