#pragma once

#include "../storage/buffer.h"
#include "../storage/fs/object.h"

namespace net
{
	/* endpoint template class */
	template<class msg_type> class endpoint
	{
	public:

		// send data
		virtual bool write(const storage::buffer&) = 0;

		// pack/unpack data
		virtual storage::buffer pack(const msg_type&) = 0;
		virtual std::shared_ptr<storage::fs::object_base> unpack(const storage::buffer&) = 0;

		// send message (ref version)
		bool send(const msg_type& msg)
		{
			return write(pack(msg));
		}

		// send message (ptr version)
		bool send(std::shared_ptr<const msg_type> msg_ptr)
		{
			if (msg_ptr == nullptr)
				return false;

			return send(*msg_ptr);
		}
	};
};
