#pragma once

#include "base.h"

namespace math::solve
{
	/* constant value */
	template<typename type> class fixed : public base<type>
	{
	public:

		// assign value on ctor
		fixed(const type value)
		{
			this->m_value = value;
		}

		virtual std::string to_string(void) const override
		{
			return type2string(this->m_value);
		}

		// change value
		void set(const type value)
		{
			this->m_value = value;

			// signal that we were changed
			this->signal();
		}

	private:

		// derivative of a const is always null
		virtual std::shared_ptr<const solve::base<type>> create_derivative(const solve::base<type>* p) const override
		{
			return nullptr;
		}

		// retrieve value
		virtual const type compute(void) const override
		{
			return this->m_value;
		}

		// we have no further dependencies
		virtual bool has_dependency(const solve::base<type>* p) const override
		{
			return false;
		}

	private:
		type m_value;
	};
};