#pragma once

#include "../../event/auto_update.h"
#include "../../strings/format.h"

#include <unordered_map>

namespace math::solve
{
	template<typename type> class manager;
	template<typename type> class fixed;

	/* base solve class */
	template<typename type> class base : /*public event::auto_update::actor, public event::auto_update::observer,*/ public std::enable_shared_from_this<base<type>>
	{
		friend class manager<type>;

	public:

		// default ctor
		base(void) {}

		// build with dependencies
		base(const std::initializer_list<std::shared_ptr<const math::solve::base<type>>>& list)
		{
			/*
			for (auto& p : list)
				this->observe(const_cast<math::solve::base<type>*>(p.get()));
			*/
		}

		// retrieve value
		const type eval(void) const
		{
			if (this->m_proxy != nullptr)
				return *this->m_proxy;

			this->m_proxy = std::make_unique<const type>(compute());

			return *this->m_proxy;
		}

		// reset value to force recompute
		void reset(void)
		{
			this->m_proxy.reset();
		}

		// check if it has the type
		bool has(const solve::base<type> *p) const
		{
			if (p == this)
				return true;

			return has_dependency(p);
		}

		// convert to string
		virtual std::string to_string(void) const = 0;

		// get derivative
		std::shared_ptr<const solve::base<type>> get_derivative(const solve::base<type>* p) const
		{
			if (p == this)
				return std::make_shared<fixed<type>>(1);

			// check if derivative already exists
			auto it = this->m_derivatives.find(p);

			if (it != this->m_derivatives.end())
				return it->second;

			// otherelse create one
			auto d = this->create_derivative(p);

			this->m_derivatives.emplace(std::make_pair(p, d));

			return d;
		}

	protected:
		
		// create derivative
		virtual std::shared_ptr<const solve::base<type>> create_derivative(const solve::base<type>* p) const = 0;

		// compute value
		virtual const type compute(void) const = 0;

		// check if we have dependency on pointer
		virtual bool has_dependency(const solve::base<type>* p) const = 0;

	protected:

		// concat string for reverse-polish notation
		static std::string concat(const std::list<std::string>& list)
		{
			std::string ret = "";

			for (auto& v : list)
			{
				if (ret != "")
					ret += " ";

				ret += v;
			}

			return ret;
		}

	private:

		// reset & signal on update
		/*
		virtual void on_update(event::auto_update::actor& p) override
		{
			// reset state
			reset();

			// signal that we were changed too
			this->signal();
		}
		*/

	private:
		mutable std::unique_ptr<const type> m_proxy;

		mutable std::unordered_map< const solve::base<type>*, std::shared_ptr<const solve::base<type>>> m_derivatives;
	};
};