#pragma once

#include "../../../debug/exdebug.h"

#include "../paraxial/abcd.h"
#include "../paraxial/yu.h"
#include "../paraxial/seidel.h"

#include "base.h"

#include <list>

namespace math::optics::system
{
	/* group class */
	template<typename type> class group : public base<type>
	{
	public:

		// ctor from list
		group(std::list<std::shared_ptr<base<type>>> children = {})
		{
			for (auto& p : children)
				push_back(p);
		}

		// add an element
		void push_back(std::shared_ptr<base<type>> p)
		{
			if (__ISNULLPTR(p))
				return;

			this->m_children.push_back(p);
		}

		// compute group overall ABCD matrix
		virtual math::optics::paraxial::abcd<type> get_paraxial_matrix(void) const override
		{
			// default is identity matrix
			math::optics::paraxial::abcd<double> M;

			// concat
			for (auto& p : this->m_children)
			{
				if (p != nullptr)
					M = p->get_paraxial_matrix() * M;
			}

			// return
			return M;
		}

		// compute group seidel aberrations
		virtual std::tuple<math::optics::paraxial::seidel<type>, math::optics::paraxial::yu<type>, math::optics::paraxial::yu<type>> get_seidel_coefficients_ex(const math::optics::paraxial::yu<type>& yu_marginal, const math::optics::paraxial::yu<type>& yu_chief) const override
		{
			// return data
			math::optics::paraxial::seidel<type> seidel_out;

			// input rays (will be modified in loop)
			math::optics::paraxial::yu<type> yu_marginal_in = yu_marginal;
			math::optics::paraxial::yu<type> yu_chief_in = yu_chief;

			// browse all elements
			for (auto& p : this->m_children)
			{
				// skip null (should never happen)
				if (__ISNULLPTR(p))
					continue;

				// compute sub-element seidel and add to sum
				auto [seidel_curr, yu_marginal_out, yu_chief_out] = p->get_seidel_coefficients_ex(yu_marginal_in, yu_chief_in);

				seidel_out = seidel_out + seidel_curr;

				// update rays positions
				yu_marginal_in = yu_marginal_out;
				yu_chief_in = yu_chief_out;
			}

			// return values
			return std::tuple(seidel_out, yu_marginal_in, yu_chief_in);
		}

	private:
		std::list<std::shared_ptr<base<type>>> m_children;
	};
};