#pragma once

#include "../paraxial/abcd.h"
#include "../paraxial/yu.h"
#include "../paraxial/seidel.h"

namespace math::optics::system
{
	/* base class */
	template<typename type> class base
	{
	public:

		// compute seidel coefficients and output vectors
		virtual std::tuple<math::optics::paraxial::seidel<type>, math::optics::paraxial::yu<type>, math::optics::paraxial::yu<type>> get_seidel_coefficients_ex(const math::optics::paraxial::yu<type>& yu_marginal_in, const math::optics::paraxial::yu<type>& yu_chief_in) const = 0;
		
		// compute ABCD matrix
		virtual math::optics::paraxial::abcd<type> get_paraxial_matrix(void) const = 0;

		// compute seidel coefficients only (drop output vectors)
		math::optics::paraxial::seidel<type> get_seidel_coefficients(const math::optics::paraxial::yu<type>& yu_marginal_in, const math::optics::paraxial::yu<type>& yu_chief_in) const
		{
			auto [seidel_curr, yu_marginal_out, yu_chief_out] = get_seidel_coefficients_ex(yu_marginal_in, yu_chief_in);

			return seidel_curr;
		}
	};
};