#pragma once

#include "../../symbolic/var.h"
#include "../../symbolic/matrix.h"

#include "exception.h"

namespace math::optics::paraxial
{
	/* YU vector class */
	template<typename type> class yu : public math::symbolic::matrix<type>
	{
	public:

		// default ctor is null values
		yu(void) : math::symbolic::matrix<type>(1, 2)
		{
			this->y() = math::symbolic::var<type>();
			this->u() = math::symbolic::var<type>();
		}

		// ctor from vars
		yu(const math::symbolic::var<type>& _y, const math::symbolic::var<type>& _u) : math::symbolic::matrix<type>(1, 2)
		{
			this->y() = _y;
			this->u() = _u;
		}

		// ctor from object
		yu(const math::symbolic::matrix<type>& other)
		{
			this->operator=(other);
		}

		// assign operator
		const yu<type>& operator=(const math::symbolic::matrix<type>& other)
		{
			// must be 1x2 matrix
			if (other.num_cols() != 1 || other.num_rows() != 2)
				throw_exception(matrix_is_not_yu_exception);

			// assign
			this->math::symbolic::matrix<type>::operator=(other);

			return *this;
		}

		// get y
		math::symbolic::var<type>& y(void)
		{
			return this->operator()(0, 0);
		}

		// get y (const version)
		const math::symbolic::var<type>& y(void) const
		{
			return this->operator()(0, 0);
		}

		// get u
		math::symbolic::var<type>& u(void)
		{
			return this->operator()(0, 1);
		}

		// get u (const version)
		const math::symbolic::var<type>& u(void) const
		{
			return this->operator()(0, 1);
		}
	};
};