#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"

#include <string>

/* invalid_matrix_exception exception class */
class invalid_matrix_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "invalid matrix!";
	}
};

/* matrix_size_mismatch_exception exception class */
class matrix_size_mismatch_exception : public exception::base
{
public:
	matrix_size_mismatch_exception(size_t rows1, size_t cols1, size_t rows2, size_t cols2)
	{
		this->m_rows1 = rows1;
		this->m_cols1 = cols1;

		this->m_rows2 = rows2;
		this->m_cols2 = cols2;
	}

	virtual std::string to_string(void) const override
	{
		char tmp[256];

		snprintf(tmp, sizeof(tmp), "Cannot perform opeation with matrices %zux%zu and %zux%zu!", this->m_cols1, this->m_rows1, this->m_cols2, this->m_rows2);

		return std::string(tmp);
	}

private:
	size_t m_rows1, m_cols1, m_rows2, m_cols2;
};

/* matrix_wrong_size_exception exception class */
class matrix_wrong_size_exception : public exception::base
{
public:
	matrix_wrong_size_exception(size_t rows, size_t cols)
	{
		this->m_rows = rows;
		this->m_cols = cols;
	}

	virtual std::string to_string(void) const override
	{
		char tmp[256];

		snprintf(tmp, sizeof(tmp), "Cannot perform opeation on %zux%zu matrix!", this->m_cols, this->m_rows);

		return std::string(tmp);
	}

private:
	size_t m_rows, m_cols;
};

/* invalid_row_exception exception class */
class invalid_row_exception : public exception::base
{
public:
	invalid_row_exception(size_t row)
	{
		this->m_row = row;
	}

	virtual std::string to_string(void) const override
	{
		char tmp[128];

		snprintf(tmp, sizeof(tmp), "Invalid row #%zu!", this->m_row);

		return std::string(tmp);
	}

private:
	size_t m_row;
};

/* invalid_column_exception exception class */
class invalid_column_exception : public exception::base
{
public:
	invalid_column_exception(size_t col)
	{
		this->m_col = col;
	}

	virtual std::string to_string(void) const override
	{
		char tmp[128];

		snprintf(tmp, sizeof(tmp), "Invalid column #%zu!", this->m_col);

		return std::string(tmp);
	}

private:
	size_t m_col;
};

/* matrix_not_invertible_exception exception class */
class matrix_not_invertible_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "matrix is not invertible!";
	}
};

/* matrix_out_of_bounds_exception exception class */
class matrix_out_of_bounds_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "trying to access matrix data out of bounds!";
	}
};

/* null_vector_exception exception class */
class null_vector_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Vector is null";
	}
};

/* wrong_dimension_vector_exception exception class */
class wrong_dimension_vector_exception : public exception::base
{
public:
	wrong_dimension_vector_exception(size_t rows, size_t cols, size_t nNumElements)
	{
		this->m_rows = rows;
		this->m_cols = cols;
		this->m_nNumElements = nNumElements;
	}

	virtual std::string to_string(void) const override
	{
		char tmp[256];

		snprintf(tmp, sizeof(tmp), "Cannot map %zu elements as %zux%zu matrix!", this->m_nNumElements, this->m_rows, this->m_cols);

		return std::string(tmp);
	}

private:
	size_t m_rows, m_cols, m_nNumElements;
};
