#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"
#include "../debug/evemon.h"
#include "../debug/exdebug.h"

#include "exception.h"
#include "base.h"

#include <string>

#ifdef _WIN32
#include <Windows.h>
#else
#include <dlfcn.h>
#endif

namespace library
{
	/* own library */
	class own : public base
	{
	public:
		own(void)
		{
			_debug("creating local handle...");

#ifdef _WIN32
			this->m_handle = GetModuleHandleA(NULL);
#else
			this->m_handle = dlopen(nullptr, RTLD_LAZY);
#endif
		}

		// get address
		virtual void* get_addr(const std::string& funcname) const override
		{
#ifdef _WIN32
			auto p = GetProcAddress(this->m_handle, funcname.c_str());
#else
			auto p = dlsym(this->m_handle, funcname.c_str());
#endif

			if (__ISNULLPTR(p))
				throw_exception(unknown_func_exception, funcname);

			return p;
		}

	private:

#ifdef _WIN32
		HMODULE m_handle;
#else
		void *m_handle;
#endif
	};
};
