#pragma once

#include "../../debug/evemon.h"
#include "../../debug/exdebug.h"

#include "../../exception.h"

#include "../library.h"

#include "manager.h"

#include <memory>
#include <string>

namespace library::interface
{
	// get external module
	template<class type> std::shared_ptr<const type> get(const std::string& library)
	{
		// get remote singleton
		auto p = get_remote_singleton<library::interface::manager>(library);

		if (__ISNULLPTR(p))
			throw_exception(null_pointer_exception);

		// get interface
		return p->get<type>();
	}

	// get local module
	template<class type> std::shared_ptr<const type> get(void)
	{
		return get<type>("");
	}

	// set local module
	template<class type> void set(const std::string& library)
	{
		_debug("changing interface \"%s\" to \"%s\"", typeid(type).name(), library.c_str());

		// get interface
		auto ifp = get<type>(library);

		// overwrite global interface
		get_remote_singleton<library::interface::manager>("")->set<type>(ifp);
	}
};

#define REGISTER_INTERFACE(impl_type, interface_type)	library::interface::manager::auto_register<interface_type> g_##interface_type(std::make_shared<impl_type>());