#pragma once

#include "../../debug/exception.h"

#include <string>

/* unknown_interface_exception exception class */
class unknown_interface_exception : public exception::base
{
public:
	unknown_interface_exception(const std::string& type)
	{
		this->m_type = type;
	}

	virtual std::string to_string(void) const override
	{
		return "Unknown interface type \"" + this->m_type + "\" !";
	}

private:
	std::string m_type;
};

/* null interface exception class */
class null_interface_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid Interface !";
	}
};