#pragma once

#include "../debug/exception.h"

#include <string>

/* invalid_libname_exception exception class */
class invalid_libname_exception : public exception::base
{
public:
	invalid_libname_exception(const std::string& libname)
	{
		this->m_libname = libname;
	}

	virtual std::string to_string(void) const override
	{
		return "Invalid library name \"" + this->m_libname + "\" !";
	}

private:
	std::string m_libname;
};

/* unknown_library_exception exception class */
class unknown_library_exception : public exception::base
{
public:
	unknown_library_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return "Unknown library \"" + this->m_filename + "\" !";
	}

private:
	std::string m_filename;
};

/* library_already_exists_exception exception class */
class library_already_exists_exception : public exception::base
{
public:
	library_already_exists_exception(const std::string& libname)
	{
		this->m_libname = libname;
	}

	virtual std::string to_string(void) const override
	{
		return "Library name \"" + this->m_libname + "\" already exists in database !";
	}

private:
	std::string m_libname;
};

/* invalid_library_exception exception class */
class invalid_library_exception : public exception::base
{
public:
	invalid_library_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return "Invalid library \"" + this->m_filename + "\" !";
	}

private:
	std::string m_filename;
};

/* unknown_func_exception exception class */
class unknown_func_exception : public exception::base
{
public:
	unknown_func_exception(const std::string& funcname)
	{
		this->m_funcname = funcname;
	}

	virtual std::string to_string(void) const override
	{
		return "Cannot find function \"" + this->m_funcname + "\" !";
	}

private:
	std::string m_funcname;
};

/* cannot_load_singleton_manager_exception exception class */
class cannot_load_singleton_manager_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot load singleton manager!";
	}
};