#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"

#include <string>

/* null_job_exception exception class */
class null_job_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid job!";
	}
};


/* job_done_exception exception class */
class job_done_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Job is not done yet!";
	}
};

/* job_adopt_exception exception class */
class job_adopt_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot adopt job!";
	}
};

/* job_release_exception exception class */
class job_release_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot release job!";
	}
};

/* job_add_exception exception class */
class job_add_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot add job!";
	}

};

/* job_queue_exception exception class */
class job_queue_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot queue job!";
	}
};

/* job_exception exception class */
class job_exception : public exception::base
{
public:
	job_exception(const std::string& message)
	{
		this->m_message = message;
	}

	virtual std::string to_string(void) const override
	{
		return "job finished with error \"" + this->m_message + "\" !";
	}

private:
	std::string m_message;
};
