#pragma once

#include "map2d.h"

MAP2D_IMPL_OPERATOR(bool, bool, &);
MAP2D_IMPL_OPERATOR(bool, bool, |);
MAP2D_IMPL_OPERATOR(bool, bool, ^);
MAP2D_IMPL_OPERATOR(bool, bool, ==);
MAP2D_IMPL_OPERATOR(bool, bool, !=);

static map2d<bool> operator!(const map2d<bool>& map)
{
	return map2d_in2out<bool, bool>(map, [](bool val)
		{
			return (bool)(!val);
		});
}

// return true if any pixel in the mask is true
bool any(const map2d<bool>& map, std::shared_ptr<const map2d<bool>> mask = nullptr)
{
	auto kernel_func = [](const bool& curr, bool val)
	{
		return curr | val;
	};

	auto redux_func = [](const std::list<bool>& list)
	{
		bool tmp = false;

		for (auto& v : list)
			tmp |= v;

		return tmp;
	};

	return map2d_redux<bool, bool, bool>(map, kernel_func, redux_func, mask);
}

// return true only if all pixels in mask are true
bool all(const map2d<bool>& map, std::shared_ptr<const map2d<bool>> mask = nullptr)
{
	auto kernel_func = [](const bool& curr, bool val)
	{
		return curr & val;
	};

	auto redux_func = [](const std::list<bool>& list)
	{
		bool tmp = true;

		for (auto& v : list)
			tmp &= v;

		return tmp;
	};

	return map2d_redux<bool, bool, bool>(map, kernel_func, redux_func, mask);
}

// return true if none of the pixels in the mask are true
bool none(const map2d<bool>& map, std::shared_ptr<const map2d<bool>> mask = nullptr)
{
	return all(!map, mask);
}