#pragma once

#include "utils/utils.h"
#include "debug/exception.h"

#include <string>
#include <cstdio>

/* unknown_exception exception class */
class unknown_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Unknown exception!";
	}
};

/* null_pointer_exception exception class */
class null_pointer_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Pointer is null!";
	}
};

/* division_by_zero_exception exception class */
class division_by_zero_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Division by zero!";
	}
};

/* function not implemented for tamplate exception class */
class template_func_not_impl_exception : public exception::base
{
public:
	template_func_not_impl_exception(const std::string& type)
	{
		this->m_type = type;
	}

	virtual std::string to_string(void) const override
	{
		return "Function is not implemented for template type \"" + this->m_type + "\" !";
	}

private:
	std::string m_type;
};

/* name_already_exist_exception exception class */
class name_already_exist_exception : public exception::base
{
public:
	name_already_exist_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Name \"" + this->m_name + "\" already exists!";
	}

private:
	std::string m_name;
};

/* name_not_found_exception exception class */
class name_not_found_exception : public exception::base
{
public:
	name_not_found_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "\"" + this->m_name + "\" was not found!";
	}

private:
	std::string m_name;
};

/* memory_allocation_exception exception class */
class memory_allocation_exception : public exception::base
{
public:
	memory_allocation_exception(const size_t size)
	{
		this->m_size = size;
	}

	virtual std::string to_string(void) const override
	{
		char szTmp[64];

		snprintf(szTmp, sizeof(szTmp), "%zu", this->m_size);

		return "Cannot allocate " + std::string(szTmp) + " bytes !";
	}

private:
	size_t m_size;
};

/* cannot_open_file_exception exception class */
class cannot_open_file_exception : public exception::base
{
public:
	cannot_open_file_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("Cannot open file \"") + this->m_filename + std::string("\" !");
	}

private:
	std::string m_filename;
};