#pragma once

#include "../threads/thread.h"
#include "../threads/event.h"

#include "base.h"

#include <memory>
#include <functional>

namespace event
{
	/* poll class */
	class poll : public thread::base
	{
	public:
		using callback_t = std::function<void(std::shared_ptr<event::base>)>;

	public:
		poll(std::shared_ptr<event::base> p, callback_t callback)
		{
			this->m_job = p;
			this->m_callback = callback;

			start();
		}

	private:
		virtual void run(void) override
		{
			if (this->m_job != nullptr && this->m_job->wait(0.1))
				this->m_callback(this->m_job);
		}

		virtual bool stop_condition(void) const override
		{
			return this->m_job != nullptr && !this->m_job->is_pending();
		}

	private:
		std::shared_ptr<event::base> m_job;
		callback_t m_callback;
	};
};