#include "auto_update.h"

event::auto_update::observer::~observer(void)
{
	for (auto& p : this->m_list)
		if (p != nullptr)
			p->unregister_observer(this);

	this->m_list.clear();
}

void event::auto_update::observer::observe(actor *p)
{
	if (p == nullptr)
		return;

	p->register_observer(this);

	{
		std::lock_guard<std::recursive_mutex> lk(this->m_lock);

		this->m_list.push_back(p);
	}
}

void event::auto_update::observer::unobserve(actor* p)
{
	if (p == nullptr)
		return;

	p->unregister_observer(this);

	{
		std::lock_guard<std::recursive_mutex> lk(this->m_lock);

		this->m_list.remove(p);
	}
}