#pragma once

namespace event
{
	/* base class */
	class base
	{
	public:

		// all events must implements 
		virtual bool wait(double timeout = 0) const = 0;
		virtual bool is_pending(void) const = 0;
		virtual void trigger(void) = 0;
		virtual void reset(void) = 0;

		// perform action until states changes
		bool do_until(std::function<void(void)> func, double timeout = 0) const
		{
			auto tick1 = std::chrono::high_resolution_clock::now();

			// loop as long as event is not signalled
			while (is_pending())
			{
				// perform func
				if (func)
					func();

				if (timeout <= 0)
					continue;

				// get current time
				auto tick2 = std::chrono::high_resolution_clock::now();

				// compute time
				auto delta_ticks = std::chrono::duration_cast<std::chrono::duration<double>>(tick2 - tick1);

				// break if delta_ticks above timeout
				if (delta_ticks.count() > timeout)
					break;
			}

			// return triggered status
			return !is_pending();
		}
	};
};