#include <map>

#include "exception.h"
#include "evemon.h"

// extended debug
std::map<std::string, std::function<void(void)>> g_exdebug_callbacks;

void exception::ex_debug(const std::string& type, std::function<void(void)> callback)
{
    if (g_exdebug_callbacks.find(type) != g_exdebug_callbacks.end())
    {
        g_exdebug_callbacks[type] = callback;

        return;
    }

    g_exdebug_callbacks.emplace(std::make_pair(type, callback));
}

// trigger a breakpoint
void breakpoint(void)
{
    __debugbreak();
}

// send exception to event monitor
void hook_exception(const exception::base& e, const std::string& type, const char* filename, unsigned int line)
{
    auto p = event_monitor::get_instance();

    if (p != nullptr)
        p->notify(event_type::DBG_EXCEPTION, filename, line, e.to_string());

    // check for extended debug
    auto it = g_exdebug_callbacks.find(type);

    if (it != g_exdebug_callbacks.end())
        if (it->second)
           it->second();
}